#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Alien TissueMod01.fsh   by  Ebanflo
//https://www.shadertoy.com/view/.....
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define AA 1
#define zoom 0.5
#define yShift -0.25

const int ITS = 50;
const float pi = 3.1415926536;
const vec2 c1 = vec2(0, 1);
const vec2 c2 = vec2(.866, -.866);
const vec2 c3 = vec2(-.866, -.866);
const float rad1 = 1.0;

vec2 circleInverse(vec2 pos, vec2 center, float rad){
    vec2 d = pos - center;
	return d * rad * rad/dot(d, d) + center;
}

vec3 gasket(vec2 pos){
    float rad2 = iMouse.x / iResolution.x + .5;
	float rad3 = iMouse.y / iResolution.y + .5;
    if(iMouse.xy == vec2(0.)) {rad2 = 1.; rad3 = 1.;}
    float index = 0.;
	for(int i = 0 ; i < ITS; i++){
		if(distance(pos, c1) < rad1){
			pos = circleInverse(pos, c1, rad1);
            index++;
		}
        else if(distance(pos, c2) < rad2){
			pos = circleInverse(pos, c2, rad2);
            index++;
		}
        else if(distance(pos, c3) < rad3){
			pos = circleInverse(pos, c3, rad3);
            index++;
		}
        else if(pos.y < 0.){
			pos = vec2(pos.x, -pos.y);
            index++;
		}
        else return vec3(pos, index);
	}
}

vec3 render(vec2 p){
    p = zoom*(2.0*p - iResolution.xy)/iResolution.y;
    p.y += yShift;
    vec3 n = gasket(p);
    float s = 0.08 * (4.0-length(n.xy)) + n.z;
    if (n.z > 44.0)return vec3(0);
    float arg = pi * s / 20. + iTime;
    vec3 col = sin(arg - vec3(0.5*pi, pi, 0.666666*pi)) * 0.5 + 0.5;
    return col*col;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec3 col = vec3(0);
    
#if AA>1
    for( int m=0; m<AA; m++ )
    for( int n=0; n<AA; n++ )
    {
    	col += render(fragCoord);    
    }
    col /= float(AA*AA);
#else
        
    col = render(fragCoord);
#endif            
    
	fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

